//------------------------------------------------------------------------------
// File: svr_destflag.cs
// This file is used for all functions related to the destination flag
// Author: Matthew Rudge
//------------------------------------------------------------------------------

$DestinationFlag = 0;

////////////////////////////////////////////////////////////////////////////////
//! Creates the destination flag for movement at a specified location
//! \param %loc Location for flag
////////////////////////////////////////////////////////////////////////////////
function createDestinationFlag(%loc)
{
   if (isObject($DestinationFlag) == true)
   {
      $DestinationFlag.delete();
   }
   
   $DestinationFlag = new StaticShape() {
      dataBlock = DestinationFlagData;
      position = %loc;
      duration = 85;
   };
}

////////////////////////////////////////////////////////////////////////////////
//! Deletes the destination flag object
//! \param %flagObj Flag object to delete
////////////////////////////////////////////////////////////////////////////////
function deleteDestinationFlag(%flagObj)
{
   // Delete flag object
   if(isObject(%flagObj)) {
      %flagObj.delete();
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Called when the destination flag is added to the simulation
//! \param %flagObj Flag object added
////////////////////////////////////////////////////////////////////////////////
function DestinationFlagData::onAdd(%this, %flagObj)
{
   // Start animation for destination flag data
   if (%flagObj.duration)
   {
      %flagObj.playThread(0, "ambient");
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Called when the animation for the flag has ended
//! \param %flagObj Flag object whose animation has ended
//! \param %slot Animation slot
////////////////////////////////////////////////////////////////////////////////
function DestinationFlagData::onEndSequence(%this, %flagObj, %slot)
{
   // Destroy destination flag
   // I'm a little concerned about deleting the object here since this
   // method is called within the object. Let's schedule for deletion.
   if (%flagObj.duration)
   {
      schedule(%flagObj.duration, 0, "deleteDestinationFlag", %flagObj);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Client call to create a destination flag
//! \param %client Client id
//! \param %loc Location to create destination flag
////////////////////////////////////////////////////////////////////////////////
function serverCmdCreateDestinationFlag(%client, %loc)
{
   createDestinationFlag(%loc);
}

// End svr_destflag.cs